/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.mixin;

import com.github.quiltservertools.ledger.actionutils.DoubleInventoryHelper;
import com.github.quiltservertools.ledger.actionutils.LocationalInventory;
import com.github.quiltservertools.ledger.callbacks.ItemInsertCallback;
import com.github.quiltservertools.ledger.callbacks.ItemRemoveCallback;
import com.github.quiltservertools.ledger.utility.HandledSlot;
import com.github.quiltservertools.ledger.utility.HandlerWithPlayer;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1735.class})
public abstract class SlotMixin
implements HandledSlot {
    private class_1703 handler = null;
    private class_1799 oldStack = null;
    @Shadow
    @Final
    public class_1263 field_7871;
    @Shadow
    @Final
    private int field_7875;

    @Shadow
    public abstract class_1799 method_7677();

    @Override
    @NotNull
    public class_1703 getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(@NotNull class_1703 handler) {
        this.handler = handler;
        this.oldStack = this.method_7677() == null ? class_1799.field_8037 : this.method_7677().method_7972();
    }

    @Inject(method={"markDirty"}, at={@At(value="HEAD")})
    private void ledgerLogChanges(CallbackInfo ci) {
        class_2338 pos = this.getInventoryLocation();
        HandlerWithPlayer handlerWithPlayer = (HandlerWithPlayer)this.handler;
        if (pos != null && handlerWithPlayer.getPlayer() != null) {
            this.logChange((class_1657)handlerWithPlayer.getPlayer(), this.oldStack, this.method_7677().method_7972(), pos);
        }
        this.oldStack = this.method_7677().method_7972();
    }

    @Unique
    @Nullable
    private class_2338 getInventoryLocation() {
        class_1263 slotInventory = this.field_7871;
        if (slotInventory instanceof DoubleInventoryHelper) {
            slotInventory = ((DoubleInventoryHelper)slotInventory).getInventory(this.field_7875);
        }
        if (slotInventory instanceof LocationalInventory) {
            return ((LocationalInventory)slotInventory).getLocation();
        }
        return null;
    }

    @Unique
    private void logChange(class_1657 player2, class_1799 stack, class_1799 newStack, class_2338 pos) {
        class_1799 changedStack;
        if (stack.method_7960() && newStack.method_7960()) {
            return;
        }
        if (!stack.method_7960() && !newStack.method_7960()) {
            if (stack.method_7909() == newStack.method_7909()) {
                int oldCount;
                int newCount = newStack.method_7947();
                if (newCount > (oldCount = stack.method_7947())) {
                    this.logChange(player2, class_1799.field_8037, new class_1799((class_1935)newStack.method_7909(), newCount - oldCount), pos);
                } else {
                    this.logChange(player2, new class_1799((class_1935)newStack.method_7909(), oldCount - newCount), class_1799.field_8037, pos);
                }
            } else {
                this.logChange(player2, stack, class_1799.field_8037, pos);
                this.logChange(player2, class_1799.field_8037, newStack, pos);
            }
            return;
        }
        boolean oldEmpty = stack.method_7960();
        class_1799 class_17992 = changedStack = oldEmpty ? newStack : stack;
        if (oldEmpty) {
            ((ItemInsertCallback)ItemInsertCallback.EVENT.invoker()).insert(changedStack, pos, (class_3218)player2.field_6002, "player", (class_3222)player2);
        } else {
            ((ItemRemoveCallback)ItemRemoveCallback.EVENT.invoker()).remove(changedStack, pos, (class_3218)player2.field_6002, "player", (class_3222)player2);
        }
    }
}

